#!/bin/sh

TFTP_SERVER=192.168.0.10
IP_ADDR=192.168.0.20

if [ -e /app/vhf_build ]; then
  if [ ! -e /tmp/www_upload/vhf_build ]; then  
    echo "Firmware does not match target hardware"
    kill 1
  fi
fi
if [ -e /app/mfhf_build_tu ]; then
  if [ ! -e /tmp/www_upload/mfhf_build_tu ]; then  
    echo "Firmware does not match target hardware"
    kill 1
  fi
fi
if [ -e /app/mfhf_build_cu ]; then
  if [ ! -e /tmp/www_upload/mfhf_build_cu ]; then
    echo "Firmware does not match target hardware"
    kill 1
  fi
fi

killall -9 s6000app.elf 2>&1
killall -9 netmanager 2>&1
killall -9 dhclient 2>&1
killall -9 slp_mon.sh 2>&1
killall -9 slpd 2>&1
killall -9 inetd 2>&1
killall -9 zcip 2>&1
killall -9 monitor_thttpd.sh 2>&1

#check if we are upgrading from very old firmware
if [ ! -e /tmp/rootfs/bin/busybox ]; then
    mkdir /tmp/rootfs
    mkdir /tmp/rootfs/sbin
    mkdir /tmp/rootfs/bin
    mkdir /tmp/rootfs/dev
    cd /tmp/rootfs/dev
    mknod mtd0 c 90 0
    mknod mtd1 c 90 2
    mknod mtd2 c 90 4
    mknod mtd4 c 90 8
    mknod console c 5 1
    
    cp /bin/busybox /tmp/rootfs/bin
    chmod u+x /tmp/rootfs/bin/busybox
    cp /usr/sbin/flashcp /tmp/rootfs/sbin
    chmod u+x /tmp/rootfs/sbin/flashcp
    
    cd /tmp/rootfs/bin
    ln -s busybox ln 
    ln -s busybox reboot 
    ln -s busybox sh
    ln -s busybox kill
    ln -s busybox sync
    ln -s busybox mount
    ln -s busybox umount
    ln -s busybox ps
    ln -s busybox rm
    ln -s busybox ls
    ln -s busybox grep
    ln -s busybox sleep
    ln -s busybox fuser  
    ln -s busybox cd  
    ln -s busybox echo     
    ln -s busybox killall
    ln -s busybox mkdir
    ln -s busybox cp
    ln -s busybox chmod
    ln -s busybox sed
    ln -s busybox dd
    ln -s busybox head
    #redirect stdout and stderr to console output
    exec 1>/tmp/rootfs/dev/console
    exec 2>/tmp/rootfs/dev/console
fi
cd /tmp/www_upload
echo "testing md5 sums"
/usr/bin/md5sum -c md5.txt
if [ $? -ne "0" ]; then
    echo "checksum does not match"
    /tmp/rootfs/bin/kill 1
fi

compareImage()
{
  echo "Compare device $1 with imagefile $2"

  FILESIZE=`/tmp/rootfs/bin/busybox ls -l $2 | /tmp/rootfs/bin/busybox sed 's/[a-z-]*. *[0-9] root *root *\([0-9]*\).*/\1/'`
  echo "filesize: $FILESIZE"

  /tmp/rootfs/bin/busybox dd if=$1 bs=512 | /tmp/rootfs/bin/busybox head -c $FILESIZE | /tmp/rootfs/bin/busybox cmp $2
  return $?
}


#We are now ready fo flash so kill webserver too
killall -9 thttpd 2>&1

echo 3 > /proc/sys/vm/drop_caches
echo 100 > /proc/sys/vm/min_free_kbytes

#clean /mnt
rm -rf /mnt/reboot_count
rm -f /mnt/rebootmax_count_reached

echo "unmounting partitions"
fuser -k /mnt
umount -lf /app
umount -lf /mnt
cd /tmp/www_upload

/tmp/rootfs/bin/mount --bind /tmp/rootfs/ /
/tmp/rootfs/bin/sync
/tmp/rootfs/bin/sleep 3

#Determine old or new kernel - should we use workaround setenv tool or not
./fw_printenv_fix
if [ $? != 0 ]; then
    echo "Fw_printenv: New kernel - use official tool"
    FW_SETENV=./fw_setenv
else
    echo "Fw_printenv: Old kernel - must use fixed tool"
    FW_SETENV=./fw_setenv_fix
fi
#Enter critical region - prepare bootloader for fallback solution
$FW_SETENV netmask 255.255.255.0
$FW_SETENV ipaddr $IP_ADDR
$FW_SETENV gatewayip 
$FW_SETENV serverip $TFTP_SERVER
$FW_SETENV bootfile s6000.tiif
$FW_SETENV bootcmd tftpboot\;progtiif\;bootm\ 0xa0030000


if [ -e u-boot.bin ]; then
    compareImage /tmp/rootfs/dev/mtd0 u-boot.bin
    if [ $? != 0 ]; then
	echo "Starting to flash uboot"
	/tmp/rootfs/sbin/flashcp u-boot.bin /tmp/rootfs/dev/mtd0
	echo "Done"
    else
	echo "Skipping flash uboot - already up to date"
    fi
fi

compareImage /tmp/rootfs/dev/mtd4 appimage.squashfs
if [ $? != 0 ]; then
    echo "Starting to flash appimage"
    /tmp/rootfs/sbin/flashcp appimage.squashfs /tmp/rootfs/dev/mtd4
    echo "Done"
else
    echo "Skipping flash appimage - already up to date"
fi

if [ -e uImage ]; then
    compareImage /tmp/rootfs/dev/mtd1 uImage
    if [ $? != 0 ]; then
	echo "Starting to flash uImage"
	/tmp/rootfs/sbin/flashcp uImage /tmp/rootfs/dev/mtd1
	echo "Done"
    else
	echo "Skipping flash uImage - already up to date"
    fi

    compareImage /tmp/rootfs/dev/mtd2 rootfs.arm.squashfs
    if [ $? != 0 ]; then
	echo "Starting to flash rootfs"
	/tmp/rootfs/sbin/flashcp rootfs.arm.squashfs /tmp/rootfs/dev/mtd2
	echo "Done"
    else
	echo "Skipping flash rootfs - already up to date"
    fi
fi

echo "Leaving critical region........"
#Leaving critical region - clear bootloader variables
$FW_SETENV netmask 
$FW_SETENV ipaddr 
$FW_SETENV gatewayip 
$FW_SETENV serverip 
$FW_SETENV bootfile 
$FW_SETENV bootcmd tiif_tftp\;bootm\ 0xa0030000

echo "Update done rebooting"
/tmp/rootfs/bin/kill 1

